/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.event;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.config.EventGeneratorData;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventGenerator;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.problem.CriticalProblem;
import com.ibm.hwmca.xfw.pa.util.LogListener;
import com.ibm.hwmca.xfw.pa.util.LogListenerInterface;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Map;

public abstract class CommonLogEventGenerator
extends ProblemAnalysisEventGenerator
implements LogListenerInterface {
    private Object _data = null;
    private static final String TRACE_MASKT = "XPACLEGT";
    private static final String TRACE_MASKF = "XPACLEGF";
    private static final String TRACE_MASKD = "XPACLEGD";
    Map eventClassMap = null;
    private static boolean paDisabled = false;
    protected static final String DISABLE_FILE_LOCATION = "paconfig";
    protected static final String DISABLE_FILE_NAME = "disable.pa";
    private static final Class[] EVENT_SIGNATURE = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = CommonLogEventGenerator.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$lang$Object;

    public CommonLogEventGenerator(EventGeneratorData eventGeneratorData, ProblemAnalysisEventManager manager) {
        super(eventGeneratorData, manager);
        Trace.trace(TRACE_MASKT, "--> ctor V5.5.04");
        this.eventClassMap = (Map)eventGeneratorData.getConfigData().get("EventClass");
        if (this.eventClassMap == null) {
            Trace.trace(TRACE_MASKT, "<-- ctor: No class mapping found in '" + eventGeneratorData.getName() + "': cannot generate events");
            return;
        }
        Trace.trace(TRACE_MASKF, "adding this as a log listener");
        LogListener.getLogListener().addListener(this);
        Trace.trace(TRACE_MASKF, "start the delyed posting thread");
        DelayPost delayThread = new DelayPost();
        Thread myThread = new Thread(delayThread);
        myThread.setDaemon(true);
        myThread.setName("Delayed Log Poster Thread");
        myThread.start();
        Trace.trace(TRACE_MASKT, "<-- ctor");
    }

    public void handle(byte logClass, byte logType, short user, long timestamp) {
        Trace.trace(TRACE_MASKF, "--> CommonLogEventGenerator.handle V 5.5.04");
        this.buildIt(logClass, logType, user, timestamp, false);
        Trace.trace(TRACE_MASKF, "<-- CommonLogEventGenerator.handle V 1.0");
    }

    public void delayHandle(byte logClass, byte logType, short user, long timestamp, Object systemRef) {
        this.buildIt(logClass, logType, user, timestamp, true);
    }

    protected void buildIt(byte logClass, byte logType, short user, long timestamp, boolean delayed) {
        if (CommonLogEventGenerator.isPADisabled()) {
            Trace.trace(TRACE_MASKT, "pa is disabled. ignore it!!!!!!");
            return;
        }
        Trace.trace(TRACE_MASKD, "--> " + this.name + ".buildIt");
        Trace.trace(TRACE_MASKD, "class     = " + HexString.toHex(logClass, true));
        Trace.trace(TRACE_MASKD, "type      = " + HexString.toHex(logType, true));
        Trace.trace(TRACE_MASKD, "user      = " + HexString.toHex(user, true));
        Trace.trace(TRACE_MASKD, "timestamp = " + new Date(timestamp).toString());
        try {
            Trace.trace(TRACE_MASKD, "get the log");
            Log log = this.getLog(logClass, logType, user, timestamp);
            if (log == null) {
                if (delayed) {
                    Trace.trace(TRACE_MASKF, "delay log wasn't there. just leave");
                    return;
                }
                Trace.trace(TRACE_MASKF, "couldn't retrieve the log ");
                return;
            }
            Trace.trace(TRACE_MASKD, "get the event");
            CommonServiceEvent event = this.getEvent(logClass, logType, user, timestamp);
            if (event != null) {
                event.setData(log);
                this.setEventSystem(event);
                if (delayed) {
                    event.getMetaData().setMeta("pdc_DELAYED_LOG", new Boolean(true));
                }
                Trace.trace(TRACE_MASKF, "post the event");
                this.fireEvent(event);
            } else {
                Trace.trace(TRACE_MASKF, "getEvent() returned 'null' event, they are choosing to ignore.");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "buildit() Received Exception");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKD, "<-- buildIt");
    }

    private Log getLog(byte logClass, byte logType, short user, long timestamp) {
        Date retrieveDate = new Date(timestamp);
        Trace.trace(TRACE_MASKD, "get log time = " + timestamp);
        Trace.trace(TRACE_MASKD, "date is = " + retrieveDate);
        Trace.trace(TRACE_MASKD, "Go get the log");
        try {
            Log[] retrievedLogs = Log.retrieve(new Byte(logClass), new Byte(logType), new Short(user), retrieveDate, retrieveDate, null, null, null);
            if (retrievedLogs.length > 0) {
                Trace.trace(TRACE_MASKD, "got the log");
                if (retrievedLogs.length > 1) {
                    Trace.trace(TRACE_MASKF, "got " + retrievedLogs.length + " logs. Just return the first");
                }
                return retrievedLogs[0];
            }
            Trace.trace(TRACE_MASKD, "couldn't find the log");
            return null;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "getLog() got exception", e);
            String refcode = HexString.toHex((byte)-86) + HexString.toHex((byte)50) + Integer.toHexString(4107);
            CriticalProblem critProb = new CriticalProblem(refcode.toUpperCase(), "00000000");
            critProb.setUnavailableServices(Long.MAX_VALUE);
            return null;
        }
    }

    protected CommonServiceEvent getEvent(byte logClass, byte logType, short user, long timestamp) {
        Trace.trace(TRACE_MASKD, "--> getEvent");
        String eventClassName = null;
        Object classValue = this.eventClassMap.get("Class-" + HexString.toHex(logClass, true));
        boolean usedWCClass = false;
        do {
            if (classValue == null) {
                usedWCClass = true;
                classValue = this.eventClassMap.get("Class-*");
            }
            if (classValue instanceof String) {
                eventClassName = (String)classValue;
            } else if (classValue instanceof Map) {
                Object typeValue = ((Map)classValue).get("Type-" + HexString.toHex(logType, true));
                boolean usedWCType = false;
                do {
                    if (typeValue == null) {
                        usedWCType = true;
                        typeValue = ((Map)classValue).get("Type-*");
                    }
                    if (typeValue instanceof String) {
                        eventClassName = (String)typeValue;
                    } else if (typeValue instanceof Map) {
                        Object userValue = ((Map)typeValue).get("User-" + HexString.toHex(user, true));
                        boolean usedWCUser = false;
                        do {
                            if (userValue == null) {
                                usedWCUser = true;
                                userValue = ((Map)typeValue).get("User-*");
                            }
                            if (userValue instanceof String) {
                                eventClassName = (String)userValue;
                            }
                            userValue = null;
                        } while (eventClassName == null && !usedWCUser);
                    }
                    typeValue = null;
                } while (eventClassName == null && !usedWCType);
            }
            classValue = null;
        } while (eventClassName == null && !usedWCClass);
        Trace.trace(TRACE_MASKD, "CommonServiceEvent Class = " + eventClassName);
        Trace.trace(TRACE_MASKD, "<-- getEvent");
        return this.newEvent(eventClassName);
    }

    protected CommonServiceEvent newEvent(String className) {
        Trace.trace(TRACE_MASKD, "--> newEvent");
        Trace.trace(TRACE_MASKD, "build event for " + className);
        if (className != null) {
            try {
                Constructor<?> eventConstructor = Class.forName(className).getConstructor(EVENT_SIGNATURE);
                return (CommonServiceEvent)eventConstructor.newInstance(this);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "newEvent() receives an exception");
                String refcode = HexString.toHex((byte)-86) + HexString.toHex((byte)50) + Integer.toHexString(4106);
                CriticalProblem critProb = new CriticalProblem(refcode.toUpperCase(), "00000000");
                critProb.setUnavailableServices(Long.MAX_VALUE);
                critProb.postIt();
            }
        } else {
            Trace.trace(TRACE_MASKF, "newEvent() null specified for class name.");
        }
        return null;
    }

    protected abstract void setEventSystem(CommonServiceEvent var1);

    public static void main(String[] args) {
        Byte logClass = null;
        Object logType = null;
        logClass = new Byte(22);
        try {
            Log[] retrievedLogs = Log.retrieve(logClass, null, null, null, null, null, null, null);
            System.out.println("got " + retrievedLogs.length + " logs back");
            if (retrievedLogs.length != 0) {
                System.out.println("got the log");
                Trace.trace(TRACE_MASKD, "got the log");
                for (int i = 0; i < retrievedLogs.length; ++i) {
                    System.out.println("relog it");
                    Trace.trace(TRACE_MASKD, "relog it.");
                    Log reLog = new Log(logClass, retrievedLogs[i].getLogType(), 0, "PA Relog", null, null, null, retrievedLogs[i].getTowerData());
                    reLog.add((byte)3, retrievedLogs[i].getLogBlock((byte)3));
                    reLog.log();
                    System.out.println("done");
                    Trace.trace(TRACE_MASKD, "relog it");
                }
            } else {
                System.out.println("couldn't find the log");
                Trace.trace(TRACE_MASKD, "couldn't find the log");
            }
        }
        catch (Exception e) {
            System.out.println("got an exception");
            e.printStackTrace();
            Trace.trace(TRACE_MASKF, "getLog() got exception", e);
        }
    }

    public static boolean isPADisabled() {
        boolean gotFile = false;
        try {
            String path = BaseFileControl.getFilePath(DISABLE_FILE_LOCATION);
            if (path != null) {
                File enableFile = new File(path + DISABLE_FILE_NAME);
                if (enableFile.exists()) {
                    Trace.trace(TRACE_MASKF, "the file exists");
                    gotFile = true;
                } else {
                    Trace.trace(TRACE_MASKF, "the file doesn't exist");
                    gotFile = false;
                }
            } else {
                Trace.trace(TRACE_MASKD, "got a null path from dfc");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got a dfc exception");
            Trace.trace(TRACE_MASKF, e);
        }
        if (gotFile) {
            if (!paDisabled) {
                paDisabled = true;
                Trace.trace(TRACE_MASKD, "PA is now disabled");
            }
        } else if (paDisabled) {
            paDisabled = false;
            Trace.trace(TRACE_MASKD, "PA is now enabled");
        }
        return paDisabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DelayPost
    implements Runnable {
        DelayPost() {
        }

        public void run() {
            Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "--> delayPost");
            try {
                Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "go to sleep... zzzzzz");
                Thread.sleep(5000L);
                Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "awake");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                File[] files;
                File directory;
                String path = BaseFileControl.getFilePath("pacrashdir");
                if (path != null && (directory = new File(path)) != null && (files = directory.listFiles(new FileFilter(this){
                    private final /* synthetic */ DelayPost this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File pathName) {
                        return pathName.getName().toLowerCase().startsWith("crash.jvm.");
                    }
                })) != null) {
                    Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "got " + files.length + " in the directory");
                    for (int i = 0; i < files.length; ++i) {
                        String filename = files[i].getName();
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "file " + i + "'s name is " + filename);
                        FileInputStream fis = new FileInputStream(files[i]);
                        byte[] data = new byte[20];
                        fis.read(data);
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "raw data was " + new String(data));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "hex data was " + HexString.toHex(data));
                        byte logClass = data[0];
                        byte logType = data[3];
                        short user = (short)(((short)data[7] & 0xFF) << 8);
                        user = (short)(user + ((short)data[6] & 0xFF));
                        long timeStamp = ((long)data[13] & 0xFFL) << 24;
                        timeStamp += ((long)data[12] & 0xFFL) << 16;
                        timeStamp += ((long)data[11] & 0xFFL) << 8;
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "first time = " + (timeStamp += (long)data[10] & 0xFFL));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "second     = " + (timeStamp *= 1000L));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "third time = " + (timeStamp += (long)(data[16] * 10)));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "logClass  = " + HexString.toHex(logClass));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "logType   = " + HexString.toHex(logType));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "user      = " + HexString.toHex(user));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "timestamp(hex) = " + HexString.toHex(timeStamp));
                        Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "timestamp      = " + timeStamp);
                        CommonLogEventGenerator.this.handle(logClass, logType, user, timeStamp);
                        try {
                            Trace.trace(CommonLogEventGenerator.TRACE_MASKD, "deleting ");
                            files[i].delete();
                            continue;
                        }
                        catch (Exception e) {
                            Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "got and exception deleting the files");
                            Trace.trace(CommonLogEventGenerator.TRACE_MASKF, e);
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "got exception", e);
                Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "got exception reading the files");
                String refcode = HexString.toHex((byte)-86) + HexString.toHex((byte)50) + Integer.toHexString(4108);
                CriticalProblem critProb = new CriticalProblem(refcode.toUpperCase(), "00000000");
                critProb.setUnavailableServices(Long.MAX_VALUE);
            }
            Trace.trace(CommonLogEventGenerator.TRACE_MASKF, "<-- delayPost");
        }
    }
}

